<?php

namespace App\Models\Demarches;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Formulaire extends Model 
{

    protected $table = 'formulaires';
    public $timestamps = false;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('nom', 'description', 'post_scriptum', 'observations', 'date_publication', 'date_derniere_modification', 'etat', 'add_by');

    public function demarches()
    {
        return $this->belongsToMany('App\Models\Demarches\Demarche');
    }

    public function pieceJointes()
    {
        return $this->morphMany('App\Models\Demarches\PieceJointe', 'modele');
    }

}